const express = require("express");
const morgan = require("morgan");
const cors = require("cors");
const routes = require("./index.routes");
const bodyParser = require("body-parser");
const path = require("path");
const https = require("https");
const http = require("http");
const fs = require("fs");
const helmet = require("helmet");
const rateLimit = require("express-rate-limit");
const gzappy = require("gzappy-js");
const db = require("./config/db");

const app = express();

app.disable("x-powered-by");

//   origin: process.env.NODE_ENV === "production" ? "https://embaixadorbrasa.com.br" : "http://localhost:3000",

const corsOptions = {
  origin: "*",
  methods: ["GET", "POST", "PUT", "PATCH", "DELETE"],
  allowedHeaders: ["Content-Type", "Authorization"],
  credentials: true,
};

app.use(cors(corsOptions));

app.use(helmet());

const limiter = rateLimit({
  windowMs: 15 * 60 * 1000,
  max: 150,
  message: {
    error: true,
    message: "Timeout error!",
    code: 408,
  },
});

app.use(limiter);

app.use(express.json({ limit: "500mb" }));
app.use(express.urlencoded({ extended: true, limit: "500mb" }));
app.use(morgan("dev"));
app.use(bodyParser.json());

app.use("/node_modules", (req, res) => {
  return res.status(403).json({ error: true, message: `Acesso negado!` });
});

app.use(routes);

const server =
  process.env.NODE_ENV === "production"
    ? https.createServer(
        {
          key: fs.readFileSync(
            path.join(
              "/home/embaixadorbrasa/ssl/keys/d3e2a_d929b_97209070913ca4fd12e627784883aea8.key",
            ),
          ),
          cert: fs.readFileSync(
            path.join(
              "/home/embaixadorbrasa/ssl/certs/_wildcard__embaixadorbrasa_com_br_d3e2a_d929b_1776388303_aa79d05acbb305f0e7c5fe82f59b07c8.crt",
            ),
          ),
        },
        app,
      )
    : http.createServer(app);

if (process.env.NODE_ENV === "production") {
  server.listen(process.env.PORT, async () => {
    console.log(`Servidor rodando na porta ${process.env.PORT}`);
  });
} else {
  server.listen(process.env.PORT, () => {
    console.log(
      `Servidor rodando em modo desenvolvimento: http://localhost:${process.env.PORT}`,
    );
  });
}

module.exports = app;
