const db = require("../../config/db");

class CentrosDeCustosRepository {

  #db = db;

  /* ================= CREATE ================= */
  async create(data) {
    try {
      await this.#db.query(
        `INSERT INTO centros_de_custos (nome, custo)
        VALUES (?, ?)`,
          [data.nome, data.custo] 
      );

      return {
        success: true,
        message: "Centro de custo cadastrado com sucesso!",
        code: 201
      };
    } catch (error) {
      return {
        error: true,
        message: "Erro ao cadastrar centro de custo",
        code: 500,
        detail: error
      };
    }
  }

  /* ================= LISTAR TODOS ================= */
  async getCentros() {
    try {
      const centros = await this.#db.query(
        `SELECT * FROM centros_de_custos`
      );

      return centros;
    } catch (error) {
      return {
        error: true,
        message: "Erro ao buscar centros de custos",
        code: 500,
        detail: error
      };
    }
  }

  /* ================= BUSCAR UM ================= */
  async getUmCentro(id) {
    try {
      const centros = await this.#db.query(
        `SELECT id, nome, custo FROM centros_de_custos WHERE id = ?`,[id]
      );

      if (!centros.length) {
        return {
          error: true,
          message: "Centro de custo não encontrado",
          code: 404
        };
      }

      return centros[0];
    } catch (error) {
      return {
        error: true,
        message: "Erro ao buscar centro de custo",
        code: 500,
        detail: error
      };
    }
  }

  /**
   * Atualiza um centro de custo
   * @param {Object} data Objeto com dados a serem atualizados 
   * @returns JSON refente ao status da operação
   */
  async update(data) {
    try {
      await this.#db.query(
        `UPDATE centros_de_custos SET nome = ?, custo = ? WHERE id = ?`,
         [data.nome, data.custo, data.id]
      );

      return {
        success: true,
        message: "Centro de custo atualizado com sucesso!",
        code: 200
      };
    } catch (error) {
      return {
        error: true,
        message: "Erro ao atualizar centro de custo",
        code: 500,
        detail: error
      };
    }
  }

  /**
   * Deleta um centro de custo
   * @param {Int} id ID do centro de custo a ser deletado
   * @returns JSON refente ao status da operação
   */
  async delete(id) {
    try {
      const centros = await this.#db.query(
        `DELETE FROM centros_de_custos WHERE id = ?`,[id] 
      );

      return {
        success: true,
        message: "Centro de custo deletado com sucesso!",
        code: 200
      };
    } catch (error) {
      return {
        error: true,
        message: "Este centro de custo possui vínculos!",
        code: 409,
        detail: error
      };
    }
  }
}

module.exports = new CentrosDeCustosRepository();
