const EstadoCidadeRepository = require("./estado_cidade.repository");

class EstadoCidadeController {

  async create(req, res) {
    try {
      const data = req.body;
      const response = await EstadoCidadeRepository.create(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getEstadosCidades(req, res) {
    try {
      const response = await EstadoCidadeRepository.getEstadosCidades();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getUmEstadoCidade(req, res) {
    try {
      const id = req.params.id;
      const response = await EstadoCidadeRepository.getUmEstadoCidade(id);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async delete(req, res) {
    try {
      const id = req.params.id;
      const response = await EstadoCidadeRepository.delete(id);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async update(req, res) {
    try {
      const data = req.body;
      const response = await EstadoCidadeRepository.update(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new EstadoCidadeController();
