const FormaPagamentoRepository = require("./Formas_pagamento.repository");

class FormaPagamentoController {

  async register(req, res) {
    try {
      const data = req.body;
      const response = await FormaPagamentoRepository.create(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getFormasPagamento(req, res) {
    try {
      const response = await FormaPagamentoRepository.getFormasPagamento();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getUmaFormaPagamento(req, res) {
    try {
      const id = req.params.id;
      const response = await FormaPagamentoRepository.getUmaFormaPagamento(id);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async delete(req, res) {
    try {
      const id = req.params.id;
      const response = await FormaPagamentoRepository.delete(id);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async update(req, res) {
    try {
      const data = req.body;
      const response = await FormaPagamentoRepository.update(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new FormaPagamentoController();
