const db = require("../../config/db");

class FormaPagamentoRepository {

  #db = db;

  /* ================= CREATE ================= */
  async create(data) {
    try {
      await this.#db.query(
        `INSERT INTO forma_pagamento (forma)
         VALUES (?)`,
        [data.forma]
      );

      return {
        success: true,
        message: "Forma de pagamento cadastrada com sucesso!",
        code: 201
      };
    } catch (error) {
      return {
        error: true,
        message: "Erro ao cadastrar forma de pagamento",
        code: 500,
        detail: error
      };
    }
  }

  /* ================= LISTAR TODOS ================= */
  async getFormasPagamento() {
    try {
      const formasPagamento = await this.#db.query(
        `SELECT * FROM forma_pagamento`
      );

      return formasPagamento;
    } catch (error) {
      return {
        error: true,
        message: "Erro ao buscar formas de pagamento",
        code: 500,
        detail: error
      };
    }
  }

  /* ================= BUSCAR UM ================= */
  async getUmaFormaPagamento(id) {
    try {
      const formasPagamento = await this.#db.query(
        `SELECT id, forma 
         FROM forma_pagamento 
         WHERE id = ?`,
        [id]
      );

      if (!formasPagamento.length) {
        return {
          error: true,
          message: "Forma de pagamento não encontrada",
          code: 404
        };
      }

      return formasPagamento[0];
    } catch (error) {
      return {
        error: true,
        message: "Erro ao buscar forma de pagamento",
        code: 500,
        detail: error
      };
    }
  }

  /**
   * Atualiza uma forma de pagamento
   * @param {Object} data
   * @returns JSON referente ao status da operação
   */
  async update(data) {
    try {
      await this.#db.query(
        `UPDATE forma_pagamento 
         SET forma = ?
         WHERE id = ?`,
        [data.forma, data.id]
      );

      return {
        success: true,
        message: "Forma de pagamento atualizada com sucesso!",
        code: 200
      };
    } catch (error) {
      return {
        error: true,
        message: "Erro ao atualizar forma de pagamento",
        code: 500,
        detail: error
      };
    }
  }

  /**
   * Deleta uma forma de pagamento
   * @param {Int} id
   * @returns JSON referente ao status da operação
   */
  async delete(id) {
    try {
      await this.#db.query(
        `DELETE FROM forma_pagamento WHERE id = ?`,
        [id]
      );

      return {
        success: true,
        message: "Forma de pagamento deletada com sucesso!",
        code: 200
      };
    } catch (error) {
      return {
        error: true,
        message: "Erro ao deletar forma de pagamento",
        code: 500,
        detail: error
      };
    }
  }
}

module.exports = new FormaPagamentoRepository();
