const PrecosRepository = require("./Precos.repository");

class PrecosController {

  async register(req, res) {
    try {

      const response = await PrecosRepository.create(req.body);
      
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getPrecos(req, res) {
    try {
      const response = await PrecosRepository.getPrecos();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getUmPreco(req, res) {
    try {
      const response = await PrecosRepository.getUmPreco(req.params.id);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async update(req, res) {
    try {
      const response = await PrecosRepository.update(req.body);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async delete(req, res) {
    try {
      const response = await PrecosRepository.delete(req.params.id);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new PrecosController();
