const QrCodeRepository = require("./Qrcode.repository");

class QrCodeController {

  async register(req, res) {
    try {

      const response = await QrCodeRepository.create(req.body, req.file);
      return res.status(response.code).json(response);

    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getQrCodes(req, res) {
    try {
      const response = await QrCodeRepository.getQrCodes();
      return res.status(200).json(response);

    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

    async gerarNumeros(req, res) {
    try {
      const response = await QrCodeRepository.gerarNumeros();
      return res.status(response.code || 200).json(response);

    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  
    async getNumeros(req, res) {
    try {
      const response = await QrCodeRepository.getNumeros();
      return res.status(200).json(response);

    } catch (error) {
      console.error(error);
      
      return res.status(500).json(error);
    }
  }

  async getUmQrCode(req, res) {
    try {
      const response = await QrCodeRepository.getUmQrCode(req.params.id);
      return res.status(200).json(response);

    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async update(req, res) {
    try {
      const response = await QrCodeRepository.update(req.body);
      return res.status(response.code).json(response);

    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async delete(req, res) {
    try {
      const response = await QrCodeRepository.delete(req.params.id);
      return res.status(response.code).json(response);

    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new QrCodeController();
