const  db = require("../../config/db");
const { Transform, pipeline } = require('stream');
const { S3Client, PutObjectCommand, GetObjectCommand, PutObjectAclCommand } = require('@aws-sdk/client-s3');
const sharp = require("sharp");

class QrCodeRepository {

  #db = db;

  constructor() {
      this.s3Client = new S3Client({
      region: process.env.S3_REGION,
      credentials: {
        accessKeyId: process.env.AWS_ACCESS_KEY_ID,
        secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY,
      },
    });
    this.S3_BUCKET = process.env.S3_BUCKET
    this.region = process.env.S3_REGION;

  }

  /* ================= CREATE ================= */
  async create(data, file) {
    try {


      let imageUrl = "";

      if (file) {
          const buffer = await sharp(file.buffer)
              .resize({ fit: "contain" })
              .toBuffer();

          const command = new PutObjectCommand({
              Bucket: process.env.S3_BUCKET,
              Key: file.originalname,
              Body: buffer,
              ContentType: file.mimetype,
          });

          await this.s3Client.send(command);

          imageUrl = `https://${this.S3_BUCKET}.s3.us-east-2.amazonaws.com/${file.originalname}`;
      }

      await this.#db.query(
        `INSERT INTO qrcode (url, titulo, query, categoria, url_destino)
         VALUES (?, ?, ?, ?, ?)`,
        [imageUrl, data.titulo, data.query, data.categoria, data.url_destino]
      );

      return {
        success: true,
        message: "QR Code cadastrado com sucesso!",
        code: 201
      };

    } catch (error) {
      console.error(error);
      return {
        error: true,
        message: "Erro ao cadastrar QR Code",
        code: 500,
        detail: error
      };
    }
  }

  /* ================= LISTAR TODOS ================= */
  async getQrCodes() {
    try {
      const qrcodes = await this.#db.query(
        `SELECT id, url, titulo, query, categoria, url_destino FROM qrcode`
      );

      return qrcodes;
    } catch (error) {
      console.error(error);
      return {
        error: true,
        message: "Erro ao buscar QR Codes",
        code: 500,
        detail: error
      };
    }
  }

  /* ================= BUSCAR UM ================= */
  async getUmQrCode(id) {
    try {
      const qrcodes = await this.#db.query(
        `SELECT id, url, titulo, query, categoria, url_destino
         FROM qrcode 
         WHERE id = ?`,
        [id]
      );

      if (!qrcodes.length) {
        return {
          error: true,
          message: "QR Code não encontrado",
          code: 404
        };
      }

      return qrcodes[0];
    } catch (error) {
      console.error(error);
      return {
        error: true,
        message: "Erro ao buscar QR Code",
        code: 500,
        detail: error
      };
    }
  }

  async  gerarNumeros() {

  const TOTAL = 500000;
  const BATCH_SIZE = 1000;

  let valores = [];

  for (let i = 1; i <= TOTAL; i++) {
    valores.push([i, `Número gerado: ${i}`]);

    // Quando atingir o tamanho do lote, insere no banco
    if (valores.length === BATCH_SIZE) {
      await this.#db.query(
        'INSERT INTO numeros (numero, numeroTXT) VALUES ?',
        [valores]
      );
      valores = [];
      console.log(`Inseridos até o número ${i}`);
    }
  }

  // Insere o resto (caso não feche exatamente em 1000)
  if (valores.length > 0) {
    await this.#db.query(
      'INSERT INTO numeros (numero, numeroTXT) VALUES ?',
      [valores]
    );
  }

  await this.#db.end();
  console.log('✅ Geração concluída!');
  return {
    success: true,
    message: "Números gerados com sucesso!",
    code: 200
  }
}


getNumeros(ultimoId, onData) {
    return new Promise((resolve, reject) => {

        const stream = pool
            .query(
                `
                SELECT id, numero
                FROM numeros
                WHERE id > ?
                ORDER BY id
                `,
                [ultimoId]
            )
            .stream({ highWaterMark: 2000 });

        stream.on("data", onData);
        stream.on("end", resolve(stream));
        stream.on("error", reject);
    });
}


// getNumeros(ultimoId, onData) {
//     return new Promise((resolve, reject) => {

//         const stream = pool
//             .query(
//                 `
//                 SELECT id, numero
//                 FROM numeros
//                 WHERE id > ?
//                 ORDER BY id
//                 `,
//                 [ultimoId]
//             )
//             .stream({ highWaterMark: 2000 });

//         stream.on("data", onData);
//         stream.on("end",  resolve);
//         stream.on("error", reject);
//     });
// }






// async getNumerosPorId(ultimoId = 0, limit = 5000) {
//     try {
//         const rows = await this.#db.query(
//             `
//             SELECT id, numero
//             FROM numeros
//             WHERE id > ?
//             ORDER BY id
//             LIMIT ?
//             `,
//             [ultimoId, limit]
//         );

//         return rows;
//     } catch (error) {
//         throw new Error("Erro ao buscar números");
//     }
// }



  /**
   * Atualiza um QR Code
   */
  async update(data) {
    try {
      await this.#db.query(
        `UPDATE qrcode 
         SET url = ?, titulo = ?, query = ?, categoria = ?, url_destino = ?
         WHERE id = ?`,
        [data.url, data.titulo, data.query, data.categoria, data.url_destino, data.id]
      );

      return {
        success: true,
        message: "QR Code atualizado com sucesso!",
        code: 200
      };

    } catch (error) {
      console.error(error);
      return {
        error: true,
        message: "Erro ao atualizar QR Code",
        code: 500,
        detail: error
      };
    }
  }

  /**
   * Deleta um QR Code
   */
  async delete(id) {
    try {
      await this.#db.query(
        `DELETE FROM qrcode WHERE id = ?`,
        [id]
      );

      return {
        success: true,
        message: "QR Code deletado com sucesso!",
        code: 200
      };

    } catch (error) {
      console.error(error);
      return {
        error: true,
        message: "Erro ao deletar QR Code",
        code: 500,
        detail: error
      };
    }
  }
}

module.exports = new QrCodeRepository();
