const express = require("express");
const router = express.Router();
const multer = require("multer");
const path = require("path")

const storage = multer.memoryStorage();


const upload = multer({ 
    storage,
    dest: "uploads/"
})
const fileStorage = multer.diskStorage({
    destination: (req, file, cb) => {
        cb(null, path.join(__dirname, '../../', 'uploads/'));
    },
    filename: (req, file, cb) => {
        cb(null, file.fieldname + ".xlsx");
    },
});
const multerUpload = multer({ storage: fileStorage });


const QrCodeController = require("./Qrcode.controller");

/* ================= QRCODE ================= */

router.post("/gerar_numeros", QrCodeController.gerarNumeros);
router.post("/", upload.single("file"), QrCodeController.register);
router.get("/numeros", QrCodeController.getNumeros);
router.get("/", QrCodeController.getQrCodes);
router.get("/:id", QrCodeController.getUmQrCode);
router.patch("/", QrCodeController.update);
router.delete("/:id", QrCodeController.delete);

module.exports = router;
