class QrCodeDTO {

  static validateCreate(data) {

    if (!data) {
      return {
        error: true,
        message: "Payload não informado",
        code: 400
      };
    }

    const { url, titulo } = data;

    if (!url || typeof url !== "string") {
      return {
        error: true,
        message: "url é obrigatória",
        code: 400
      };
    }

    if (!titulo || typeof titulo !== "string") {
      return {
        error: true,
        message: "titulo é obrigatório",
        code: 400
      };
    }

    return { success: true };
  }

}

module.exports = QrCodeDTO;
