const UnidadesRepository = require("./Unidades.repository");

class UnidadesController {
    
  async register(req, res) {
    try {

      const response = await UnidadesRepository.create(req.body);
      
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getUnidades(req, res) {
    try {
      const response = await UnidadesRepository.getUnidades();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getUmaUnidade(req, res) {
    try {
      const response = await UnidadesRepository.getUmaUnidade(req.params.id);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async update(req, res) {
    try {
      const response = await UnidadesRepository.update(req.body);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async delete(req, res) {
    try {
      const response = await UnidadesRepository.delete(req.params.id);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new UnidadesController();
