const fs = require('fs');
const path = require('path');
const nodemailer = require('nodemailer');
require('dotenv').config({path:__dirname+'/../../.env'});

const email_host = process.env.EMAIL_HOST || "mail.croissantecia.com.br";
const email_user = process.env.EMAIL_USER || "promocao@croissantecia.com.br"; 
const email_pass = process.env.EMAIL_PASSWORD || "Croissant@2025#123"; 

async function enviarEmail(cliente, cupomValido) {

  const templatePath = path.join(__dirname, '../templates/registrosConcluido.html');
  let templateHtml = fs.readFileSync(templatePath, 'utf-8');

  templateHtml = templateHtml.replace(/{{cupom}}/g, cupomValido);
   
  const transporter = nodemailer.createTransport({
    host: email_host, 
    port: 587,
    secure: false,
    auth: {
      user: email_user, 
      pass: email_pass  
    },
    authMethod: 'LOGIN',
    tls: {
      rejectUnauthorized: false
    },
    debug: true,
    logger: true
});

  const mailOptions = {
    from: email_user, 
    to: cliente.email,
    subject: "Registro Concluído",
    html: templateHtml,
  };

  try {
    const info = await transporter.sendMail(mailOptions);
    console.log("E-mail enviado:", info.messageId);
    return { success: true, message: "E-mail enviado com sucesso!", code: 200 };
  } catch (error) {
    console.error("Erro detalhado ao enviar e-mail:", error);
    return { error: true, message: "Erro ao enviar e-mail", code: 500 };
  }
}

module.exports = { enviarEmail };